% function to solve heat conduction in 1-d slab
% using Duhamel's summation
%   we use the Duhamel's summation to compute the temperatrue
%function [Tout] = Duhamel_q( x, t, qfunc )
%   responses at the x-locations contained in 'x' at the
%   times contained in 'dt' using the external function 
%   describing the surface heating contained in 'qfunc'
function [Tout] = Duhamel_q( x, t, qfunc )
A = 15;
nx = max(size(x,1),size(x,2));
nt = max(size(t,1),size(t,2));  %could be column or row vector
time = t - t(1);                % could have negative times!
Tout = zeros( nt, nx );   % nt rows by nx columns

q = feval( qfunc, t(2:nt) - (t(2)-t(1))/2 );
for i = 1:nx
%   phi = finite_q( x(i), time(2:nt) );  % get phi's for this x(i) 
   phi = fdX22B10T0( x(i), time(2:nt), A );  % get phi's for this x(i) 
   dphi = diff( [ 0;phi ] );
   Tout(1,i) = 0;              % start with initial temperature
	for M = 1 : nt - 1
	   Tout(M+1,i) = 0;
      for n = 1:M
      	Tout(M+1,i) = Tout(M+1,i) + q(n)*dphi(M-n+1);
   	end
   end
end

