% Example 3.10 - solve Example 3.2 using Dirichlet formulation
time = [ -0.2400 -0.0600  0.1200  0.3000  0.4800  0.6600  0.8400 ...
          1.0200  1.2000  1.3800  1.5600  1.7400 ]';
Y = [  0.0000  0.0000  0.0034  0.0337  0.0964  0.1907  0.2790 ...
       0.3351  0.3588  0.3600  0.3600  0.3600 ]';
x = 0.5;  % measurement location at x=0.5
dt = time(2) - time(1);
time_fine = [ -.24:0.006:1.8 ]';
N = length(Y);
r = 1;
[qhat That] = Beck_T( dt, x, r, Y );
figure(96); clf; 
plot( time(1:N-r) - dt/2, qhat, 'ro', time_fine, q_triangle(time_fine), ... 
      'k--', 'linewidth', 1.0)

xlabel('time')
ylabel('Heat Flux')

fig=figure(96);
print(fig,fullfile(pwd, 'Figure3_13b.tif'),'-dtiff','-r600')

figure(95); clf; 
plot( time(1:N-r) - dt/2, That, 'ro', time_fine, 0.6*T_1pulse(time_fine, 0, 1.2, 0), ... 
      'k--', 'linewidth', 1.0)

xlabel('time')
ylabel('Temperature')

fig=figure(95);
print(fig,fullfile(pwd, 'Figure3_13a.tif'),'-dtiff','-r600')


