% Example 3.10
time = [ -.24: 0.06: 1.8]';

Y = [ ...
0.0000000	0.0000000 0.0000000 0.0000000 0.0000000 0.0003952 0.0034040 ...
0.0099142 0.0200152 0.0337153 0.0510153 0.0719153 0.0964153 0.1245153 ...
0.1562153 0.1907249 0.2236072 0.2530868 0.2789849 0.3012847 0.3199847 ...
0.3350847 0.3465847 0.3544847 0.3587847 0.3598799 0.3599888 0.3599990 ...
0.3599999 0.3600000 0.3600000 0.3600000 0.3600000 0.3600000 0.3600000 ...
]';

dt = time(2) - time(1);
x = 0.5;
N = length(Y);

time_fine = [ -.24:0.006:1.8 ]';
figure(96); clf; 
plot( time_fine, q_triangle(time_fine),'k--', 'linewidth', 1.0, ...
    'DisplayName', 'Exact')
hold on

figure(95); clf; 
plot( time_fine, 0.6*T_1pulse(time_fine, 0, 1.2, 0), ... 
      'k--', 'linewidth', 1.0, 'DisplayName', 'Exact')
hold on

rvec = [ 1 2 3 5 ];
legstr = [ "ro-", "bd", "ks", "mv" ];
for (ir = 1:length(rvec))
    r = rvec(ir);
    [qhat That] = Beck_T( dt, x, r, Y );
    figure(96)
    plot( time(1:N-r) - dt/2, qhat, legstr(ir),'linewidth', 1.0, ...
        'DisplayName', sprintf('$r =%2d$', r) );
    figure(95)
    plot( time(1:N-r) - dt/2, That, legstr(ir),'linewidth', 1.0, ...
        'DisplayName', sprintf('$r =%2d$', r) );
    
end
figure(96)
hold off
% axis( [ -.5 2 -.4 .9 ] )
xlabel('time')
ylabel('Heat Flux')
set(groot, 'defaultLegendInterpreter', 'latex');
legend('location','northwest')


fig=figure(96);
print(fig,fullfile(pwd, 'Figure3_15b.tif'),'-dtiff','-r600')

figure(95)
hold off
axis( [ -.5 2 0 .45 ] )
xlabel('time')
ylabel('Temperature')
legend('location','northwest')

fig=figure(95);
print(fig,fullfile(pwd, 'Figure3_15a.tif'),'-dtiff','-r600')
