% Example 3.13
t = [ -.24:0.06:1.8];
dt = t(2) - t(1);
x = 0.5;
nx = 101;
nxstar = x*(nx-1) + 1  % location of x=0.5 if there are 101 nodes
N = length(t);
[t_triangle, T_triangle] = ode15s(@Tdot_func_q_func, t, zeros(101,1), [], 1.0 );
figure(1); clf; plot( t_triangle - dt/2, T_triangle(:, nxstar),...
             'ro--', 'linewidth', 1.0)
xlabel('time'); ylabel('Temperature')

fprintf('  time   T(x=0.5)\n')
fprintf(' %5.2f  %9.6f\n', [ t_triangle  T_triangle(:,nxstar)]' )

fig=figure(1);
print(fig,fullfile(pwd, 'Figure3_17.tif'),'-dtiff','-r600')
