% Example 3.12
% use NonlinearSFSM with no noise 
load triangle.mat;  % contains 't_triangle' and 'T_triangle' (data at x=0.5)
Y = T_triangle;
time = t_triangle;
dt = time(2) - time(1);
N = length(Y);
x = 0.5;
rvec = [ 2 ];  % values of r to consider
legstr = [ "ro", "bd", "ks" ];

nr = length(rvec);
hhat = zeros(N, nr);

figure(99); clf; hold on

for ir = 1:nr
    r = rvec(ir);
    [qhat, Tsur ,That] = NonlinearSFSM( dt, x, r, Y );
    plot( time(1:N-r) - dt/2, qhat(1:N-r), legstr(ir), 'linewidth', 1.0, 'DisplayName', sprintf('$r$ =%2d',r) )
end
tfine = [ time(1): dt/10 : time(end) ];
plot( tfine, q_triangle( tfine) , 'k--', 'DisplayName', 'Exact' );
xlabel('time'); ylabel('Temperature');
legend show

% fig = figure(99);
% print(fig,fullfile(pwd, 'Figure3_18.tif'),'-dtiff','-r600')


    