% Example 3.15
% use NonlinearSFSM_h with noisy data 
load Example3_15_data;  % contains 'time' and 'T_5pct' (noisy data)
Y = T_5pct;
dt = time(2) - time(1);
N = length(Y);
Tinf = 1.0;
x = 0.5;
rvec = [ 3  5];  % values of r to consider
legstr = [ "ro", "bd", "ks" ];

nr = length(rvec);
hhat = zeros(N, nr);

figure(99); clf; hold on

for ir = 1:nr
    r = rvec(ir);
    tic
    [qhat(:,ir),Tsur,That] = NonlinearSFSM( dt, x, r, Y );
    tCPU = toc;
    plot( time(1:N-r), qhat(1:N-r,ir), legstr(ir), 'linewidth', 1.0, 'DisplayName', sprintf('$r$ =%2d',r) )
    fprintf(' r = %2d, CPU = %7.5f s\n', r, tCPU);
end

tfine = [ time(1): dt/10 : time(end) ];
plot( tfine, q_triangle( tfine) , 'k--', 'linewidth', 1.0, 'DisplayName', 'Exact' );
xlabel('time'); ylabel('Temperature');
legend show
hold off


% fig = figure(99);
% print(fig,fullfile(pwd, 'Figure3_19.tif'),'-dtiff','-r600')


    