% Example 3.16
% use NonlinearSFSM_h with noiseless data from Table 3.12
load triangle;  % contains 't_triangle' and 'T_triangle' (noise free data)
Y = T_triangle;
time = t_triangle;
dt = time(2) - time(1);
N = length(Y);
Tinf = 1.0;
x = 0.5;
rvec = [  2 ];  % values of r to consider
legstr = [ "ro", "bd", "ks" ];

nr = length(rvec);
hhat = zeros(N, nr);

figure(99); clf; hold on

for ir = 1:nr
    r = rvec(ir);
    [hhat(:,ir),Tsur,That] = NonlinearSFSM_h( dt, x, r, Y, Tinf );
    plot( time(1:N-r)-dt/2, hhat(1:N-r,ir), legstr(ir), 'linewidth', 1.0, 'DisplayName', sprintf('r =%2d',r) )
end
load('hexact_triangle_01.mat');  % contains 't' and 'hexact_tri' 
plot( t01, hexact_tri, 'k--', 'DisplayName', 'Exact' );
xlabel('time'); ylabel('Heat Transfer Coefficient');
legend show

%     fig = figure(99);
%     print(fig,fullfile(pwd, 'Figure3_20.tif'),'-dtiff','-r600')


    