% Example 3.3data - noisy data from triangle heat flux
t = [ -.24:0.18:1.8]';
x = 0.5;
peak = 0.6;
pct = [ 0.005 0.01 0.05 ];
T_exact = peak*T_1pulse(t, 0, 1.2, x)';
T_noise = zeros(length(t), length(pct));
rng(129);  % seed random number
sigma = round(max(T_exact)*pct,3);
fprintf(' sigma:');
fprintf('    %6.4f', sigma)
fprintf('\n')
noise = randn(length(t), length(pct));
for i = 1:length(pct)
    noise(:,i) = sigma(i)*noise(:,i);
    T_noise(:,i) = T_exact(:) + noise(:,i);
end
fprintf(' %5.2f  %9.6f  %9.6f  %9.6f\n', [ t T_noise]' )

