% Example 3.5
time = [ -0.2400 -0.0600  0.1200  0.3000  0.4800  0.6600  0.8400 ...
          1.0200  1.2000  1.3800  1.5600  1.7400 ]';
Y = [  0.0000  0.0000  0.0034  0.0337  0.0964  0.1907  0.2790 ...
       0.3351  0.3588  0.3600  0.3600  0.3600 ]';
dt = time(2) - time(1);
x = 0.5;
N = length(Y);
time_fine = [ -.24:0.006:1.8 ]';
figure(96); clf; 
plot( time_fine, q_triangle(time_fine),'k--', 'linewidth', 1.0, ...
    'DisplayName', 'Exact')
hold on

rvec = [ 1 3 5 ];
legstr = [ "ro", "bd", "ks", "mv" ];
for (ir = 1:length(rvec))
    r = rvec(ir);
    qhat = Beck( dt, x, r, Y );
    plot( time(1:N-r) - dt/2, qhat, legstr(ir),'linewidth', 1.0, ...
        'DisplayName', sprintf('$r =%2d$', r) );
end
hold off

xlabel('time')
ylabel('Heat Flux')
set(groot, 'defaultLegendInterpreter', 'latex');
legend show


% fig=figure(96);
% print(fig,fullfile(pwd, 'Figure3_6.tif'),'-dtiff','-r600')