% Example 3.6
time = [ -0.2400 -0.0600  0.1200  0.3000  0.4800  0.6600  0.8400 ...
          1.0200  1.2000  1.3800  1.5600  1.7400 ]';
Y01 = [-0.004206  -0.004206  0.005432  0.031767  0.102075  0.190454...
        0.277610   0.338322  0.358413  0.355197  0.359953  0.362502 ]';
Y05 = [ -0.004134  -0.003218  0.031233  -0.000487  0.089262  0.229876...
         0.282059  0.358537  0.340391  0.353100  0.342752  0.329812 ]'



dt = time(2) - time(1);
x = 0.5;
Y = Y05;  % choose data noise level: Y01 or Y05
N = length(Y);
time_fine = [ -.24:0.006:1.8 ]';
figure(96); clf; 
plot( time_fine, q_triangle(time_fine),'k--', 'linewidth', 1.0, ...
    'DisplayName', 'Exact')
hold on

rvec = [ 1 2 3 5 ];
legstr = [ "ro", "bd", "ks", "mv" ];
for (ir = 1:length(rvec))
    r = rvec(ir);
    qhat = Beck( dt, x, r, Y );
    plot( time(1:N-r) - dt/2, qhat(1:N-r), legstr(ir),'linewidth', 1.0, ...
        'DisplayName', sprintf('$r =%2d$', r) );
end
hold off

xlabel('time')
ylabel('Heat Flux')
set(groot, 'defaultLegendInterpreter', 'latex');
legend show

% fig=figure(96);
% print(fig,fullfile(pwd, 'Figure3_7.tif'),'-dtiff','-r600')