% Example 3.9
% time = [ -0.2400 -0.0600  0.1200  0.3000  0.4800  0.6600  0.8400 ...
%           1.0200  1.2000  1.3800  1.5600  1.7400 ]';
% Y = [  0.0000  0.0000  0.0034  0.0337  0.0964  0.1907  0.2790 ...
%        0.3351  0.3588  0.3600  0.3600  0.3600 ]';

time = [ -0.24	-0.18	-0.12	-0.06	0	0.06	0.12	0.18 ...
    0.24	0.3	0.36	0.42	0.48	0.54	0.6	0.66	0.72 ...
    0.78	0.84	0.9	0.96	1.02	1.08	1.14	1.2	1.26 ...
    1.32	1.38	1.44	1.5	1.56	1.62	1.68	1.74	1.8 ]';
Y = [  0	0	0	0	0	0.0003952	0.003404	0.0099142	... 
    0.0200152	0.0337153	0.0510153	0.0719153	0.0964153	... 
    0.1245153	0.1562153	0.1907249	0.2236072	0.2530868	... 
    0.2789849	0.3012847	0.3199847	0.3350847	0.3465847	... 
    0.3544847	0.3587847	0.3598799	0.3599888	0.359999	... 
    0.3599999	0.36	0.36	0.36	0.36	0.36	0.36 ]';

dt = time(2) - time(1);
x = 0.5;
N = length(Y);

istate = 129;
rng(istate);

STD = 0.0036; %Standard Deviation of the Noise
%  noise = randn(size(T_tilde))*STD;    % T_Tilde not defined
noise = randn(size(Y))*STD;
Y = Y+noise;

time_fine = [ -.24:0.006:1.8 ]';
figure(96); clf; 
plot( time_fine, q_triangle(time_fine),'k--', 'linewidth', 1.0, ...
    'DisplayName', 'Exact')
hold on


rvec = [ 3 5 8 ];

legstr = [ "ro", "bd", "ks", "mv" ];
for ir = 1:length(rvec)
    r = rvec(ir);
    [qhat, Tsur] = SFS_Quad( dt, x, r, Y );
    plot( time(1:N-r) , qhat, legstr(ir),'linewidth', 1.0, ...
        'DisplayName', sprintf('r =%2d', r) );
end
hold off

xlabel('time')
ylabel('Heat Flux')
set(groot, 'defaultLegendInterpreter', 'default');
legend show


figure(120);
Tsur_exact = 0.6*T_1pulse(time, 0, 1.2, 0)';
plot( time, Tsur_exact,'k--', 'linewidth', 1.0, ...
   'DisplayName', 'Exact')
hold on

for ir = 1:length(rvec)
    r = rvec(ir);
    [qhat, Tsur] = SFS_Quad( dt, x, r, Y );
    plot( time(1:N-r) , Tsur, legstr(ir),'linewidth', 1.0, ...
        'DisplayName', sprintf('$r =%2d$', r) ); 
end
hold off

xlabel('time')
ylabel('Temperature')
set(groot, 'defaultLegendInterpreter', 'latex');
legend show
% fig=figure(96);
% print(fig,fullfile(pwd, 'Figure3_12.tif'),'-dtiff','-r600')