% Figure 4.1
% generate a piecewise constant representation for a function
tbase = [ 0.  .25 .5 .75  1.  1.25 1.5  1.75  1.8 ]';
vals =  [ 0.   .4 .5  .8  1.2 1.3  1.15 0.9  0.8 ]';
figure(99); clf;
% plot( tbase, vals, 'ro', 'linewidth', 1.0 )
xlabel('time'); ylabel('Heat Flux');
xtickformat('%3.1f'); ytickformat('%3.1f');
tfine = [ 0:0.05:max(tbase) ];
qfine = spline(tbase, vals, tfine);
hold on
plot( tfine, qfine, 'k-','linewidth', 1.0  )
dt = 0.20;
tconst = [ dt: dt: max( tbase) ] - dt/2;
qconst = spline(tbase, vals, tconst);
for i = 1:length(tconst)
    x = [ tconst(i)-dt/2 tconst(i)-dt/2 tconst(i)+dt/2 tconst(i)+dt/2 ];
    y = [ 0 qconst(i) qconst(i) 0 ];
    line(x,y,'Color','red','LineStyle','-', 'linewidth', 1.0 )
end
ishow = 4;
line( [tconst(ishow) tconst(ishow)], [0 qconst(ishow)], 'Color','black','LineStyle','--', 'linewidth', 0.75 )
text( tconst(ishow)-dt*1.1, qconst(ishow), '$q_i$', 'Interpreter', 'Latex', 'fontsize', 14)
text( tconst(ishow)-dt/3, qconst(ishow)*0.15, '$t_{i-{1\over2}}$',...
     'Interpreter', 'Latex', 'fontsize', 14, 'BackgroundColor', 'w')
 
   fig = figure(99);
   print(fig,fullfile(pwd, 'Figure3_1.tif'),'-dtiff','-r600')
