clear; clf;

tM = 1.5;
dt = 1;
t_vals = [tM-dt, tM-.5*dt, tM];  % t_{M-2}, t_{M-1}, t_M

% Define corresponding heat flux values 
q_vals = [4.5, 5, 4.7];  % q_{M-2}, q_{M-1}, q_M

% Fit a second-order polynomial: q(t) = a*t^2 + b*t + c
coeffs = polyfit(t_vals, q_vals, 2);

% Generate fine t-points to plot smooth curve (future and past)
% t_fine = linspace(tM-2*dt, tM+2*dt, 200);
t_fine = linspace(tM-dt, tM+2*dt, 200);
q_fine = polyval(coeffs, t_fine);

% Customize ticks and labels
xticks([0.5 1 1.5 2 2.5]);
xticklabels({'t_{M-2}', 't_{M-1}', 't_{M}', 't_{M+1}', 't_{M+2}'});
yticklabels({});

set(gca, 'YMinorTick', 'off');
set(gca, 'YTick', []); 

% Plot known data points
hold on;
plot(t_vals (1:2), q_vals(1:2), 'ko', 'MarkerFaceColor', 'k', 'MarkerSize', 6); % solid circles
set(gca, 'XAxisLocation', 'origin');

% % Plot blue quadratic curve (case a)
% plot(t_fine, q_fine, 'b--', 'LineWidth', 1.8);
% Define segments:
t1 = t_vals(1);  % First point (tM-dt)
t3 = t_vals(3);  % Third point (tM)

% Generate fine t-points for each segment
t_segment1 = linspace(t1, t3, 150);               % Solid segment up to tM
t_segment2 = linspace(t3, tM+2*dt, 150);          % Dashed segment after tM

% Evaluate polynomial on both segments
q_segment1 = polyval(coeffs, t_segment1);
q_segment2 = polyval(coeffs, t_segment2);

% Plot first segment (Solid Blue)
plot(t_segment1, q_segment1, 'k-', 'LineWidth', 1.8);

% Plot second segment (Dashed Blue)
plot(t_segment2, q_segment2, 'k--', 'LineWidth', 1.8);

% Plot future estimated points
t_future = [tM tM+0.5*dt, tM+dt];
q_future = polyval(coeffs, t_future);
plot(t_future, q_future, 'ko', 'MarkerFaceColor', 'w', 'MarkerSize', 6); % open circles

% Connect known points (t_vals) to x-axis with dotted lines
for i = 1:length(t_vals)
    line([t_vals(i) t_vals(i)], [0 q_vals(i)], 'LineStyle', ':', 'Color', 'r', 'LineWidth', 1.2);
end

% Connect future points (t_future) to x-axis with dotted lines
for i = 1:length(t_future)
    line([t_future(i) t_future(i)], [0 q_future(i)], 'LineStyle', ':', 'Color', 'r', 'LineWidth', 1.2);
end

% Example positions for known points (adjust as needed)
text(t_vals(1)-0.1, q_vals(1)+0.1, 'q_{M-2}', 'HorizontalAlignment', 'right', 'VerticalAlignment', 'middle', 'FontSize', 12);
text(t_vals(2), q_vals(2)+0.3, 'q_{M-1}', 'HorizontalAlignment', 'right', 'VerticalAlignment', 'middle', 'FontSize', 12);
text(t_vals(3), q_vals(3)+0.5, 'q_{M}',   'HorizontalAlignment', 'right', 'VerticalAlignment', 'middle', 'FontSize', 12);

% Example positions for future points (adjust as needed)
text(t_future(2)+0.1, q_future(2)+0.1, 'q_{M+1}', 'HorizontalAlignment', 'center', 'VerticalAlignment', 'bottom', 'FontSize', 12);
text(t_future(3)+0.1, q_future(3)+0.2, 'q_{M+2}', 'HorizontalAlignment', 'center', 'VerticalAlignment', 'bottom', 'FontSize', 12);

% Labels and style
xlabel('t');
ylabel('q(t)');
% title('Second Order Heat Flux Functional Form (Case a: N_{past} = 2)');

% Force axes to start from zero
% xlim([0 tM+2.5*dt]);  % start from t=0
% ylim([0 max([q_vals, q_future]) + 1]);  % start from q=0

xlim([0 4]);  % start from t=0
ylim([-1.5 6]);  % start from q=0


% axis tight;
% grid on;
% box on;

% fig=figure(1);
% print(fig,fullfile(pwd, 'Figure3_11.tif'),'-dtiff','-r600')
