
% Data points for Heat Flux vs Time
x = linspace(0, 10, 11);  % time
y = [0, 0.5, 2.5, 3.6, 4., 4.1, 3.2, 3.3, 4.1, 4.0, 2.5];  % heat flux
y = y+1.5;

xx = linspace(min(x), max(x), 500);
yy = spline(x, y, xx);  % Spline-interpolated smooth curve
clf
% Plotting
figure(1); clf;
hold on;

% Plot the smooth black solid curve
plot(xx, yy, 'k-', 'LineWidth', 1.5);

% Plot the linear segments connecting the points
plot(x, y, 'red-', 'LineWidth', 1.2);


% Plot circle markers
plot(x, y, 'ko', 'MarkerFaceColor', 'w', 'LineWidth', 1.2);

% Plot vertical dashed lines from each point to x-axis
for i = 1:length(x)
    plot([x(i), x(i)], [0, y(i)], 'r-');
end

% Axis arrows
annotation('arrow', [0.1, 0.9], [0.1, 0.1], 'Color', 'k'); % x-axis
annotation('arrow', [0.1, 0.1], [0.1, 0.9], 'Color', 'k'); % y-axis

% Axis limits and styling
xlim([min(x)-0.5, max(x)+0.5]);
ylim([0, max(y)*1.1]);
axis off;
set(gcf, 'Color', 'w');

% Add labels manually
text(mean(x), -0.3, 'Time', 'FontSize', 10, 'HorizontalAlignment', 'center');
text(-1.4, mean(y)-1, 'Heat flux', 'FontSize', 10, 'Rotation', 90, 'HorizontalAlignment', 'center');

text(1, -0.4, 't_M_-_1', 'FontSize', 11, 'HorizontalAlignment', 'center');
text(2, -0.4, 't_M', 'FontSize', 11, 'HorizontalAlignment', 'center');
text(3, -0.4, 't_M_+_1', 'FontSize', 11, 'HorizontalAlignment', 'center');
dx = x(2) - x(1);
line( [ x(2) + dx/2,  x(3) + dx/2], [ y(3), y(3) ], 'LineStyle', '--','Color', 'k', 'LineWidth', 1.0 )
text(x(2) + dx/4, y(3), 'q_M', 'FontSize', 11, 'HorizontalAlignment', 'center');
line( [ x(1) + dx/2,  x(2) + dx/2], [ y(2), y(2) ], 'LineStyle', '--', 'Color', 'k', 'LineWidth', 1.0 )
text(x(1) + dx/4, y(2), 'q_M_-_1', 'FontSize', 11, 'HorizontalAlignment', 'center');

slope = ( y(3) - y(2))/dx;
xfine = x(2):dx/10:x(4);
line(  xfine, y(2)+slope*(xfine-x(2)), 'LineStyle', '--', 'LineWidth', 1.5, 'Color', 'k' )

% fig=figure(1);
% print(fig,fullfile(pwd, 'Figure3_9.tif'),'-dtiff','-r600')

