function [TdotXdot] = TdotXdot_func_h( t, TX, L, h_M, T_inf )
% function to compute the derivative of temperature at all
%  the nodal locations in a 1-D spatially discretized finite 
%  element domain.  We will use a Runge-Kutta like 
%  scheme to perform the time integration.
%  The derivatives of the sensitivity problem for h are also computed
%  and appended to the Tdot vector (T and X must be computed
%  in parallel due to the dependence on the thermal properties
%
%  modified from function TdotXdot_func
%
%   t  - scalar time value of the current time step (t_M)
%  TX  - vector of length 2*n_nodes contains all the T's and X_h's
%          for the current time step
%   L  - scalar length of the 1-D domain (in m or ft)
% h_M  - scalar current value of the heat transfer coefficient at time t_M
% T_inf- scalar value of the environment temperature (K or F)
%
n_nodes = length( TX )/2;  % how many are there
T = TX(1:n_nodes);         % get T only
X_h = TX(n_nodes+1 : 2*n_nodes );  % this is X only
n_ele = n_nodes - 1;    % for 1-D there are one less elements
dx = L / n_ele;
for i = 1:n_ele
    Tavg(i,1) = (T(i)+T(i+1))/2;  % these are at the interfaces b/w nodes
end
khalf = k_func ( Tavg );
knode = k_func ( T );   % compute at the nodes also
Cnode = C_func( T );

Tdot= zeros( n_nodes,1 );
Xdot_h = zeros( n_nodes, 1 );
for i = 2:n_nodes-1
    Tdot(i) = (khalf(i)*(T(i+1)-T(i)) - khalf(i-1)*(T(i)-T(i-1)) )/dx^2/Cnode(i);
    Xdot_h(i) = (khalf(i)*(X_h(i+1)-X_h(i)) - ...
                  khalf(i-1)*(X_h(i)-X_h(i-1)))/dx^2/Cnode(i);
% use energy balance concepts
%     Tdot(i) = (khalf(i)*(T(i+1)-T(i)) - khalf(i-1)*(T(i)-T(i-1)) )/dx/Cnode(i)/dx;
%     Xdot_h(i) = (khalf(i)*(X_h(i+1)-X_h(i)) - khalf(i-1)*(X_h(i)-X_h(i-1)) )/dx/Cnode(i)/dx;
end
Tdot(1) = ( -3*h_M*(T(1)-T_inf)+4*khalf(1)*(T(2)-T(1))/dx - ...
               knode(2)*(T(3)-T(1))/2/dx )/dx/Cnode(1);
Xdot_h(1) = ( -3*(T(1)-T_inf + h_M*X_h(1))+4*khalf(1)*(X_h(2)-X_h(1))/dx - ...
               knode(2)*(X_h(3)-X_h(1))/2/dx )/dx/Cnode(1);
Tdot(n_nodes)=( -4*khalf(n_ele)*(T(n_nodes) - T(n_nodes-1))/dx + ...
          knode(n_nodes-1)*(T(n_nodes)-T(n_nodes-2))/2/dx )/dx/Cnode(n_nodes);

Xdot_h(n_nodes)=( -4*khalf(n_ele)*(X_h(n_nodes) - X_h(n_nodes-1))/dx + ...
          knode(n_nodes-1)*(X_h(n_nodes)-X_h(n_nodes-2))/2/dx )/dx/Cnode(n_nodes);
% Tdot(1) = (h_M*(T_inf-T(1)) + (T(2) - T(1))*khalf(1)/dx)/Cnode(i)/(dx/2);
% Xdot_h(1) =( (T_inf-T(1) - X_h(1)*h_M) + (X_h(2) - X_h(1))*khalf(1)/dx)/Cnode(i)/(dx/2);
%  
% Tdot(n_nodes) = (T(n_nodes-1) -T(n_nodes))*khalf(n_nodes-1)/dx/Cnode(n_nodes)/(dx/2);
% Xdot_h(n_nodes) = (X_h(n_nodes-1) -X_h(n_nodes))*khalf(n_nodes-1)/dx/Cnode(n_nodes)/(dx/2);
% 

TdotXdot = [ Tdot; Xdot_h ];

return

function [C] = C_func( T )
% C = ones( length( T ) );
% C = 2.5 ./ ( T + 0.5 );
% this is for non-linear cases
C = 1 ./ ( 2*T + 1 );
return

function [k]=k_func(T)
% k = ones( length(T) );
% k = -25*T.*T + 20 * T + 1;
% this is for non-linear cases
k = 1+4*T.^2;
return
