% Perform Whole Domain function specification method
%  with Tikhonov regularization (zeroth order)
%   -dimensionless data must be supplied
%   -geometry is the insulated finite plate
%   -uses function build_X_finite_N.m which uses finite_q.m
% dt is the dimensionless time step in the data
%  x is a scalar dimensionless measurement location
%  Y is the vector of measurements beginning at time=dt
% alpha is the Tikhonov regularization parameter
% function [qhat, Tsur] = WholeDomainTik0( dt, x, Y, alpha )
function [qhat, Tsur] = WholeDomainTik0( dt, x, Y, alpha )
if( nargin == 0 )
   dt = 1;
   x = 0.5;
   Y = [1:1:10]';
   alpha = 1.e-10;
end

N = size(Y,1);   % the total number of observations
if( N == 1 )
   error('Y must be a column vector');
end
X = Build_X_finite_N( x, dt, N );

qhat = (X'*X + alpha*eye(N)) \ X'*Y;
%
% now we know all the q components.  
% Compute the surface temperature via Beck's Eq. 3.2.12
time = [dt:dt:N*dt]';
X0 = build_X_finite_N( 0, dt, N ); % get the sensitivity values @ x=0

Tsur = X0 * qhat;





   


