% function [X]=build_X_finite_N( x, dt, N )
% build the X matrix for a 1-D q-based
%  inverse heat conduction problem.
%  x is sensor location, dt is time interval, 
%  and N is the order of the square matrix
function [X]=build_X_finite_N( x, dt, N )
time = [ dt : dt : N*dt]';
phi = zeros(N,1);
phi(2:N) = finite_q( x, time );
phi(1) = 0;   % it is NaN otherwise due to t=0 in semi_q
N = size(phi,1) - 1;   % number of rows and cols - skip time = 0
X = zeros( N, N ); % initialize to zero
for i = 1:N        % take each column in turn
   for j = 1: N-i+1 % length from diagonal to bottom row   
      X( j+i-1, i ) = phi( j + 1 ) - phi( j );
   end
end
