function [X]=build_X_finite_T_N( x, dt, N )
%function [X]=build_X_finite_T_N( x, dt, N )
% build the X matrix for a 1-D T-based
%  inverse heat conduction problem.
%  x is sensor location, dt is time interval, 
%  and N is the order of the square matrix
time = [ dt : dt : N*dt]';
U = zeros(N,1);
U(2:N+1) = finite_T( x, time );
U(1) = 0;   % it is NaN otherwise due to t=0 in semi_q
N = size(U,1) - 1;   % number of rows and cols - skip time = 0
X = zeros( N, N ); % initialize to zero
for i = 1:N        % take each column in turn
   for j = 1: N-i+1 % length from diagonal to bottom row   
      X( j+i-1, i ) = U( j + 1 ) - U( j );
   end
end
