% function returns U(x,t) = theta*k/(q0*L) = (T(x,t) - Tinf)*k/q0/L
% for a finite domain excited with a unity temperature x = 0
% Woodbury/Jin(1995) Equation (6) - below x is "x+" and t is "t+"
% function [ U ] = finite_T( x, t )
function [ U, sum ] = finite_T( x, t )
steady = 1;
nt = 1000;
sum = 0;
for n = 1:nt
   nhalf = n - 0.5;
   sum = sum + exp(-nhalf^2*pi^2.*t)*sin(nhalf*pi*x)/nhalf;
end
U = steady - sum*2/pi ;
