% function returns dU(x,t)/dx = d(theta)/dx*k/(q0*L) 
%   this function is used to compute heat flow from T field
% Woodbury/Jin(1995) Equation (14) - below x is "x+" and t is "t+"
% function [ Uprime ] = finite_T_deriv( x, t )
function [ Uprime ] = finite_T_deriv( x, t )
nt = 1000;
sum = 0;
for n = 1:nt
   nhalf = n - 0.5;
   sum = sum + exp(-nhalf^2*pi^2.*t)*cos(nhalf*pi*x);
end
Uprime = -sum*2 ;
