% function returns Tplus = theta*k/(q0*L) = (T(x,t) - Tinf)*k/q0/L
% for a finite domain heated with a 
% constant heat flux at x = 0
% Beck Equation 1.5.5 - below x is "x+" and t is "t+"
% function [ Tplus ] = finite_q( x, t )
function [ Tplus, sum ] = finite_q( x, t )
steady = t + 1/3 - x + x^2/2;
nt = 1000;
sum = 0;
for n = 1:nt
   sum = sum + exp(-n^2*pi^2.*t)*cos(n*pi*x)/n^2;
end
Tplus = steady - sum*2/pi^2 ;
